/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.fluid;

import com.hrznstudio.titanium.fluid.TitaniumFluid;
import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import java.util.function.Consumer;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class TitaniumFluidInstance {
    private RegistryObject<FluidType> fluidType;
    private RegistryObject<Fluid> flowingFluid;
    private RegistryObject<Fluid> sourceFluid;
    private RegistryObject<Item> bucketFluid;
    private RegistryObject<Block> blockFluid;
    private final String fluid;

    public TitaniumFluidInstance(DeferredRegistryHelper helper, String fluid, FluidType.Properties fluidTypeProperties, final IClientFluidTypeExtensions renderProperties, CreativeModeTab group) {
        this.fluid = fluid;
        this.sourceFluid = helper.registerGeneric(ForgeRegistries.FLUIDS.getRegistryKey(), fluid, () -> new TitaniumFluid.Source(this));
        this.flowingFluid = helper.registerGeneric(ForgeRegistries.FLUIDS.getRegistryKey(), fluid + "_flowing", () -> new TitaniumFluid.Flowing(this));
        this.fluidType = helper.registerGeneric(ForgeRegistries.Keys.FLUID_TYPES, fluid, () -> new FluidType(fluidTypeProperties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(renderProperties);
            }
        });
        this.bucketFluid = helper.registerGeneric(ForgeRegistries.ITEMS.getRegistryKey(), fluid + "_bucket", () -> new BucketItem(this.sourceFluid, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(group)));
        this.blockFluid = helper.registerGeneric(ForgeRegistries.BLOCKS.getRegistryKey(), fluid, () -> new LiquidBlock(() -> (FlowingFluid)this.sourceFluid.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_222994_()));
    }

    public RegistryObject<FluidType> getFluidType() {
        return this.fluidType;
    }

    public RegistryObject<Fluid> getFlowingFluid() {
        return this.flowingFluid;
    }

    public RegistryObject<Fluid> getSourceFluid() {
        return this.sourceFluid;
    }

    public RegistryObject<Item> getBucketFluid() {
        return this.bucketFluid;
    }

    public RegistryObject<Block> getBlockFluid() {
        return this.blockFluid;
    }

    public String getFluid() {
        return this.fluid;
    }
}

